# Copyright (c) 2006-2007, H. Andres Lagar-Cavilla, University of Toronto
# In the context of the vmgl project
#
# See the file LICENSE.txt for information on redistributing this software.

import sys

sys.path.append( "../glapi_parser" )
import apiutil

apiutil.CopyrightC()

print """
/* Copyright (c) 2006-2007, H. Andres Lagar-Cavilla, University of Toronto.
 * In the context of the vmgl project. */
 
/* DO NOT EDIT - THIS FILE GENERATED BY THE diffgen.py SCRIPT */
#include "cr_spu.h"
#include "cr_packfunctions.h"
#include "packspu.h"
#include "packspu_proto.h"

#include <stdio.h>

static const CRPixelPackState defaultPacking = {
	0, 		/* Row Length */
	0, 		/* Skip Rows */
	0, 		/* Skip Pixels */
	1, 		/* Alignment */
	0, 		/* Image Height */
	0, 		/* Skip Images */
	GL_FALSE, 	/* Swap Bytes */
	GL_FALSE  	/* LSB First */
};

"""

keys = apiutil.GetDispatchedFunctions("../glapi_parser/APIspec.txt")

## We will use the state tracker diff infrastructure to push OpenGL
## state to the new GL stub upon resume. Once computedd differences,
## the Diff Dispatch Table is invoked to perform whatever action you
## want on the diffed state. In our case, we simply want to send
## the state to new GL stub. This script generates s Diff Dispatch
## Table that does just that. It's exceedingly simple for non-pixel
## functions. We need to hack a default packing when shipping pixel 
## functions calls.

for func_name in apiutil.AllSpecials( "packspu_diffpixel" ):
	return_type = apiutil.ReturnType(func_name)
	decl = apiutil.MakeDeclarationString(apiutil.Parameters(func_name))
	print 'extern %s PACKSPU_APIENTRY packspu_Diff%s( %s );' % ( return_type, func_name, decl )

print '\n'

for func_name in apiutil.AllSpecials( "packspu_diffpixel" ):
	return_type = apiutil.ReturnType(func_name)
	params = apiutil.Parameters(func_name)
	print '%s PACKSPU_APIENTRY packspu_Diff%s( %s )' % (return_type, func_name, apiutil.MakeDeclarationString( params ) )
	print '{'
	params.append( ('&defaultPacking', 'blah', 0) )
	print '\tif (pack_spu.swap)'
	print '\t{'
	print '\t\tcrPack%sSWAP( %s );' % (func_name, apiutil.MakeCallString( params ) )
	print '\t}'
	print '\telse'
	print '\t{'
	print '\t\tcrPack%s( %s );' % (func_name, apiutil.MakeCallString( params ) )
	print '\t}'
	print '}\n'

print """
void packspuCreateDiffTable( void )
{"""

for func_name in keys:
	props = apiutil.Properties(func_name)

	if "get" in props:
		print '\tpack_spu.diff_DT.%s = NULL;' % func_name
	elif apiutil.FindSpecial( "packspu_diff", func_name ):
		print '\tpack_spu.diff_DT.%s = crState%s;' % (func_name, func_name)
	elif apiutil.FindSpecial( "packspu_diffpixel", func_name ):
		print '\tpack_spu.diff_DT.%s = packspu_Diff%s;' % (func_name, func_name)
	else:
		print '\tpack_spu.diff_DT.%s = (pack_spu.swap ? crPack%sSWAP : crPack%s);' % (func_name, func_name, func_name)
print '\tcrStateDiffAPI( &pack_spu.diff_DT );'
print '}'
