# Copyright (c) 2006-2007, H. Andres Lagar-Cavilla, University of Toronto
# In the context of the vmgl project
#
# See the file LICENSE.txt for information on redistributing this software.

import sys

sys.path.append( "../glapi_parser" )
import apiutil

apiutil.CopyrightC()

## This generates another Dispatch Table. When a display list is called
## the DLM replays its contents and changes to state have to be recorded
## on the state tracker. We pass the State Dispatch Table generated below
## To the DLMReplayCallList(s). It is essentially a shortcut for all 
## appropriate calls to be applied to the state tracker

print """
/* Copyright (c) 2006-2007, H. Andres Lagar-Cavilla, University of Toronto.
 * In the context of the vmgl project. */

/* DO NOT EDIT - THIS FILE GENERATED BY THE stategen.py SCRIPT */
#include "cr_spu.h"
#include "cr_packfunctions.h"
#include "packspu.h"
#include "packspu_proto.h"

/* This function is called through the dispatch table below when we hit a
 * compiled CallList function. Essentially a recursive hack. */
static void PACKSPU_APIENTRY packspu_StateCallList( GLuint list )
{
    crDLMReplayListState(list, &pack_spu.state_DT);
}
    
/* This function is called through the dispatch table below when we hit a
 * compiled CallLists function. Essentially a recursive hack. */
static void PACKSPU_APIENTRY packspu_StateCallLists( GLsizei n, GLenum type, const GLvoid * lists )
{
    crDLMReplayListsState(n, type, lists, &pack_spu.state_DT);
}

void packspuCreateStateTable( void )
{"""

keys = apiutil.GetDispatchedFunctions("../glapi_parser/APIspec.txt")

for func_name in keys:
	# These functions are special to the state API
	if func_name in ['CallList', 'CallLists']:
	    print '\tpack_spu.state_DT.%s = (%sFunc_t) packspu_State%s;' % (func_name, func_name, func_name)
	elif apiutil.SetsTrackedState(func_name):
	    print '\tpack_spu.state_DT.%s = (%sFunc_t) crState%s;' % (func_name, func_name, func_name)
	else:
	    print '\tpack_spu.state_DT.%s = NULL;' % (func_name)
print '}'
