# Copyright (c) 2001, Stanford University
# All rights reserved.
#
# See the file LICENSE.txt for information on redistributing this software.


import sys

sys.path.append("../glapi_parser")
import apiutil

keys = apiutil.GetDispatchedFunctions("../glapi_parser/APIspec.txt")

apiutil.CopyrightC()

print """
/* DO NOT EDIT - THIS FILE GENERATED BY THE NULLfuncs.py SCRIPT */

#include "cr_error.h"
#include "stub.h"
"""

for func_name in keys:
	return_type = apiutil.ReturnType(func_name)
	params = apiutil.Parameters(func_name)

	print "static %s SPULOAD_APIENTRY NULL_%s( %s )" % (return_type, func_name, apiutil.MakeDeclarationString(params))
	print "{"
	print "\t/* do nothing */"
	print "\tcrWarning(\"YOU ARE CALLING A NULLED FUNCTION (%s)\");" % func_name
	for (name, type, vecSize) in params:
		print "\t(void) %s;" % name
	if return_type != "void":
		print "\treturn 0;"
	print "}"
	print ""


print "SPUDispatchTable stubNULLDispatch = {"
for func_name in keys:
	print "\tNULL_%s," % (func_name)
print "\tNULL,  /* copyList */"
print "\tNULL,  /* copy_of */"
print "\t0,     /* mark */"
print "\tNULL   /* server */"
print "};"

print ""
print "/* Declare and initialize the glim dispatch table here so that we */"
print "/* can initialize all entries to no-op routines. */"
print "SPUDispatchTable glim = {"
for func_name in keys:
	print "\tNULL_%s," % (func_name)
print "\tNULL,  /* copyList */"
print "\tNULL,  /* copy_of */"
print "\t0,     /* mark */"
print "\tNULL   /* server */"
print "};"
